﻿

CREATE PROCEDURE [App].[NVCC_usp_GetNVAMeds]
	-- Add the parameters for the stored procedure here
	@pid bigint -- this is the patientsid
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler (Original script by Dr. Charles Demosthenes)
--Object/SP Name		: NVCC_usp_GetNVAMeds
--SERVER				: 
--Data Base				: CC_REFDOC
--Schema				: App
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 02-05-2016
--
--Changed               : 03-03-2016  
--Changed By		    : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Added NonVAMedComments per TFS NVCC project task 1329.
--                        Also added NonVAMedDisclamer, and a condition that
--                        the DiscontinuedDateTime is NULL.
--
--Changed               : 02-05-2016  
--Changed By            : Jerry Kohler - Northwest Innovation Center (NWIC)
--Reason For Change		: Removed station parameter in order to expand the search
--                        for a patient's VA meds from a single station to any
--                        station a patient is associated with.
--
--Purpose               : Retrieve a patient's medications not issued by VA for
--                        inclusion into NVCC documentation
--=================================================================================
BEGIN

	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

  	SELECT DISTINCT n.Sta3n
          ,App.udf_StationName (n.Sta3n) AS StationName
          ,n.NonVAMedSID
		  ,d.LocalDrugNameWithDose
          ,n.Dosage
          ,n.MedicationRoute
	      ,n.Schedule
          ,n.NonVAMedComments
          ,n.NonVAMedDisclaimer
	FROM CDWWork.NonVAMed.NonVAMed n
    INNER JOIN CDWWork.Dim.LocalDrug d ON n.LocalDrugSID = d.LocalDrugSID
	WHERE n.PatientSID in (select PtSID from [App].[udf_AllPatientsSIDs](@pid))
      AND n.DiscontinuedDateTime is NULL;
        
END;



